from typing import List, Dict

# Question 1 : Compléter le code avec une boucle par index
contacts: List[Dict] = [
	{"nom": "tehei", "prenom": "mehiti"},
	{"nom": "hauata", "prenom": "manu"},
	{"nom": "wei", "prenom": "lin"},
	{"nom": "durand", "prenom": "pierre"}
]

print("Contacts avant normalisation :")
print(contacts)

for i in range(len(contacts)):
    nom_majuscules: str = contacts[i]["nom"].upper()
    prenom_capitalize: str = contacts[i]["prenom"].capitalize()
    contacts[i]["nom"] = nom_majuscules
    contacts[i]["prenom"] = prenom_capitalize

print("\nContacts après normalisation (boucle index) :")
print(contacts)



# Question 2 : Réécrire la boucle avec "for each"
contacts: List[Dict] = [ # Réinitialisation des données
	{"nom": "tehei", "prenom": "mehiti"},
	{"nom": "hauata", "prenom": "manu"},
	{"nom": "wei", "prenom": "lin"},
	{"nom": "durand", "prenom": "pierre"}
]

for contact in contacts:
    contact["nom"] = contact["nom"].upper()
    contact["prenom"] = contact["prenom"].capitalize()

print("\nContacts après normalisation (boucle for each) :")
print(contacts)



# Question 3 & 4 : Créer et utiliser une fonction
from typing import List, Dict

def normaliser_noms(contacts_a_normaliser: List[Dict]) -> None:
    """
    Normalise une liste de contacts en mettant les noms en majuscules
    et les prénoms avec une première lettre en majuscule.
    @param contacts_a_normaliser La liste de dictionnaires de contacts à modifier en entrée / sortie.
    """
    for contact in contacts_a_normaliser:
        contact["nom"] = contact["nom"].upper()
        contact["prenom"] = contact["prenom"].capitalize()
    # Aucun return, la liste est modifiée en place

if __name__ == "__main__":
	contacts: List[Dict] = [
		{"nom": "tehei", "prenom": "mehiti"},
		{"nom": "hauata", "prenom": "manu"},
		{"nom": "wei", "prenom": "lin"},
		{"nom": "durand", "prenom": "pierre"}
	]

	print("\nContacts avant de passer par la fonction :")
	print(contacts)
	normaliser_noms(contacts)
	print("\nContacts après avoir utilisé la fonction :")
	print(contacts)
